<?php

require_once(dirname(__FILE__) . '/utility.php');

/* do NOT move this line */
declare(ticks = 1);
$percentage = 0;
$status_map = array();
$sem = '';
$shm = '';

function deploy($argv) {
    global $BACKEND;
    
    $deploy_step_file=$argv[0];
    if(count($argv) != 1) {
        _error_report('Usage: deploy DEPLOY_STEP_FILE\n');
        exit(1);
    }
    
    _become_daemon();

    global $sem, $shm;
    if(($key = ftok(dirname(__FILE__) . '/../backend.php', 'b')) == -1) {
        _error_report('ftok error');
    }
    if(($sem = sem_get($key)) == false) {
        _error_report('sem_get error');
    }
    if(($shm = shm_attach($key)) == false) {
        _error_report('shm_attach error');
    }	
    
    $step_map = array();
    $fh_deploy_step_file = fopen($deploy_step_file, "r");
    while(($one_step = fgets($fh_deploy_step_file)) != FALSE) {
        $one_step = trim($one_step);
        list($step_name, $step_script) = explode("|", $one_step);
        $step_map[$step_name] = $step_script;
    }
    fclose($deploy_step_file);
    
    global $status_map;
    foreach($step_map as $name => $script) {
        $status_map[$name] = '-0';
    }
    
    $step_count = count($step_map);
    $idx = 0;
    foreach($step_map as $name => $script) {
        _step($name, $BACKEND . " $script 2>&1", floor(100/$step_count)*$idx, floor(100/$step_count));
        $idx++;
    }
    
    _done();
}


function _step( $step_name, $command, $percentage_base, $percentage_quota ) {
    debug_print( "launch $step_name: " ) ;
    debug_print( "    command = $command" ) ;

    global $percentage, $status_map ;

    $newpid = pcntl_fork() ;
    if( $newpid == -1 ) {
        _error_report( "CreateSubProcessFail: step='$step_name'" ) ;
    }
    
    # parent process enters here
    else if( $newpid == 0 ) {
        exec( $command, $result_array, $return_value ) ;
        exit( $return_value ) ;
    }

    # sub process enters here to count progress percentage
    $done = false ;
    $percentage = $percentage_base ;
    for( $i = 1 ; $i <= 99 ; $i++ ) {
        $status_map[ $step_name ] = -$i ;
        $percentage = $percentage_base + floor( $percentage_quota / 99 * $i ) ;
        if( $percentage >= 100 ) {
            $percentage = 99 ;
        }

        # function 'pcntl_waitpid' will return:
        # '-1', error
        #  '0', means no child exited (child is running)
        # '>0', exited process-id,
        # and store 'status information' in the variable '$statusInfo' which can
        # be evaluated by following function 'pcntl_wexitstatus'
        $exited_pid = pcntl_waitpid( $newpid, $statusInfo, WNOHANG ) ;
        if( $exited_pid == -1 ) {
            _error_report( "WaitSubProcessDoneFail: pid='$newpid'" ) ;
        }
        
        else if( $exited_pid != 0 ) {
            $retCode = pcntl_wexitstatus( $statusInfo ) ;
            if( $retCode != 0 ) {
                _error_report( "SubProcessExitedWithError: retCode='$retCode', exitedPid='$exited_pid'\n\n" . shm_get_error() ) ;
            }
            $done = true ;
            break ;
        }
        
        _update_status() ;
        sleep( 5 ) ;
    }
    _update_status() ;

    # when running out of quata, sub-process is still running
    if( !$done ) {
    
        # wait until the sub-process is done
        $exited_pid = pcntl_waitpid( $newpid, $statusInfo ) ;
        if( $exited_pid == -1 ) {
            _error_report( "WaitSubProcessDoneFail: pid='$newpid'" ) ;
        }
        
        $retCode = pcntl_wexitstatus( $statusInfo ) ;
        if( $retCode != 0 ) {
            _error_report( "SubProcessExitedWithError: retCode='$retCode', exitedPid='$exited_pid'\n\n" . shm_get_error() ) ;
        }
    }

    $status_map[ $step_name ] = '-100' ;
    _update_status() ;
}

function _done() {
    global $percentage;

    $percentage = 100;
    _update_status();
}

function _error_report( $message ) {
    global $percentage, $status_map ;

    debug_print( $message ) ;
    $percentage = -1 ;
    $status_map = array() ;
    $status_map[ 'ERROR_MESSAGE' ] = $message ;
    _update_status() ;
    exit( 1 ) ;
}

function _update_status() {
    global $percentage, $status_map, $sem, $shm;

    $deployment_status = $percentage . "\n";
    foreach($status_map as $key => $value) {
        $deployment_status .= "$key\n$value\n";
    }

    if(sem_acquire($sem) == false) {
        debug_print('sem_acquire_error');
        exit(1);
    }
    /* put shared variable to magic '5667' */
    if(shm_put_var($shm, 5667, $deployment_status) == false) {
        debug_print('shm_put_var error');
        exit(1);
    }
    if(sem_release($sem) == false) {
        debug_print('sem_release error');
        exit(1);
    }
}

function _become_daemon() {
    $newpid = pcntl_fork();
    if($newpid == -1) {
        _error_report('pcntl_fork error');
    } else if($newpid) {
        exit(0);
    }
    posix_setsid();
    $newpid = pcntl_fork();
    if($newpid == -1) {
        _error_report('pcntl_fork error');
    } else if($newpid) {
        exit(0);
    }
}

